﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports Microsoft.Win32

''' <summary>
''' 读取最高的三个得分并将这些得分写入注册表。
''' </summary>
''' <remarks></remarks>
Public Class HighScores

    ''' <summary>
    ''' 从注册表读取得分。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetHighScores() As HighScore()
        Dim tops(2) As HighScore
        Dim scoreKey As RegistryKey = Registry.CurrentUser.CreateSubKey("Software\VBSamples\Collapse\HighScores")
        For index As Integer = 0 To 2
            Dim key As String = "place" & index.ToString
            Dim score As New HighScore(CStr(scoreKey.GetValue(key)))
            tops(index) = score
        Next
        scoreKey.Close()
        Return tops
    End Function


    ''' <summary>
    ''' 更新并写入高分。
    ''' </summary>
    ''' <param name="score"></param>
    ''' <remarks></remarks>
    Public Shared Sub UpdateScores(ByVal score As Integer)
        Dim tops(3) As HighScore
        Dim scoreKey As RegistryKey = Registry.CurrentUser.CreateSubKey("Software\VBSamples\Collapse\HighScores")
        tops(0) = New HighScore(scoreKey.GetValue("Place0").ToString)
        tops(1) = New HighScore(scoreKey.GetValue("Place1").ToString)
        tops(2) = New HighScore(scoreKey.GetValue("Place2").ToString)
        If score > tops(2).Score Then
            Dim name As String = InputBox("New high score of " & score & " for:")
            tops(3) = New HighScore(" :0")
            tops(3).Name = name
            tops(3).Score = score
            Array.Sort(tops)
            Array.Reverse(tops)
            scoreKey.SetValue("Place0", tops(0).ToString)
            scoreKey.SetValue("Place1", tops(1).ToString)
            scoreKey.SetValue("Place2", tops(2).ToString)
        End If
        scoreKey.Close()
    End Sub

    ''' <summary>
    ''' 为新得分建立项。
    ''' </summary>
    ''' <remarks></remarks>
    Shared Sub SetUpHighScores()
        Dim scoreKey As RegistryKey = Registry.CurrentUser.CreateSubKey("Software\VBSamples\Collapse\HighScores")
        If scoreKey.GetValue("Place1") Is Nothing Then
            scoreKey.SetValue("Place0", " :0")
            scoreKey.SetValue("Place1", " :0")
            scoreKey.SetValue("Place2", " :0")
        End If
        scoreKey.Close()
    End Sub

    ''' <summary>
    ''' 重置得分。
    ''' </summary>
    ''' <remarks></remarks>
    Shared Sub ResetScores()
        Dim scoreKey As RegistryKey = Registry.CurrentUser.CreateSubKey("Software\VBSamples\Collapse\HighScores")
        scoreKey.SetValue("Place0", " :0")
        scoreKey.SetValue("Place1", " :0")
        scoreKey.SetValue("Place2", " :0")
        scoreKey.Close()
    End Sub

End Class




